
#include <iostream>
#include <GL/glew.h>
#include <GL/glut.h>
#include <math.h>
#include <corona.h>
#include "textfile.h"

GLhandleARB vertex, fragment, program;
float anim = 0.0f;
float ldir[4];


void idle(void) {
	anim += 0.01f;
	
	ldir[0] = sinf(anim);
	ldir[1] = cosf(anim);
	ldir[2] = 1.0f;
	ldir[3] = 0.0f;

	glutPostRedisplay();
}


void reshape(int w, int h) {
	float ratio = (float)w / (float)h;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f, ratio, 1.0f , 100.0f);

    glViewport(0, 0, w, h);
}


void display(void) {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glLightfv(GL_LIGHT0, GL_POSITION, ldir);
	gluLookAt(0.0f, 0.0f, 5.0f, 
		      0.0f, 0.0f, -1.0f,
			  0.0f, 1.0f, 0.0f);

	glRotatef(100.0f * anim, 0.0f, 1.0f, 0.0f);
	glutSolidTeapot(1.0f);

	glutSwapBuffers();
}

void keyboard(unsigned char key, int x, int y) {
	switch (key) {
		case 27:
			exit(0);
	}
}


void setShaders() {
	GLcharARB *v = 0, *f = 0;

	v = textFileRead("vertex.txt");
	f = textFileRead("fragment.txt");

	vertex = glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB);
	fragment = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);

	glShaderSourceARB(vertex, 1, (const GLcharARB **)&v, 0);
	glShaderSourceARB(fragment, 1, (const GLcharARB **)&f, 0);

	free(v);
	free(f);

	glCompileShaderARB(vertex);
	glCompileShaderARB(fragment);

	char str[1024];
	GLsizei len;
	glGetShaderInfoLog(vertex, 1024, &len, str);
	std::cout << str << std::endl;
	glGetShaderInfoLog(fragment, 1024, &len, str);
	std::cout << str << std::endl;


	program = glCreateProgramObjectARB();

	glAttachObjectARB(program, vertex);
	glAttachObjectARB(program, fragment);

	glLinkProgramARB(program);
	glUseProgramObjectARB(program);
}


void loadTexture() {
	corona::Image* img = corona::OpenImage("marble.jpg");
	if (!img) {
		exit(-1);
	}
	
	corona::FlipImage(img, corona::CA_X);

	GLuint tex;
	glGenTextures(1, &tex);

	glBindTexture(GL_TEXTURE_2D, tex);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, img->getWidth(), img->getHeight(), 0, GL_RGB, GL_UNSIGNED_BYTE, img->getPixels());

	GLint samplerLoc = glGetUniformLocation(program, "diffuseMap");
	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D, tex);
	glUniform1i(samplerLoc, tex);

	delete img;
}

int main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowSize(500, 500);
	glutCreateWindow("GLSL lambertian reflection");

	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard);
	glutIdleFunc(idle);

	glEnable(GL_DEPTH_TEST);
	glClearColor(0.1, 0.2, 0.3, 0.4);

	glewInit();
	if (!GLEW_ARB_vertex_shader && GLEW_ARB_fragment_shader) {
		printf("No GLSL support\n");
		exit(1);
	}

	setShaders();
	loadTexture();

	glutMainLoop();

	return 0;
}

